% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qDTGIW.R
\name{qDTGIW}
\alias{qDTGIW}
\title{The quantile function for Discrete Transmuted Generalized Inverse Weibull (DTGIW) distribution.}
\usage{
qDTGIW(p, alpha, beta, lambda, theta, lower.tail = TRUE, log.p = FALSE)
}
\arguments{
\item{p}{vector of probabilities}

\item{alpha}{shape parameter#1.}

\item{beta}{scale parameter.}

\item{lambda}{shape pameter#2.}

\item{theta}{the transmuted parameter.}

\item{lower.tail}{logical; if TRUE (default), probabilities are Prob of X less than or equal to x. Otherwise, Prob of X greater than x.}

\item{log.p}{logical(TRUE or FALSE); if log.p=FALSE, then return the cdf; if log.p=TRUE, then return the natural logarithms of the cdf.}
}
\value{
the quantile values of DTGIW distribution
}
\description{
This function calculated the quantile values of the DTGIW distribution.
}
\details{
The R script calculated the quantile values of the DTGIW distribution is shown based on the research paper in references.
}
\examples{
x <- c(0:10)
p<- pDTGIW(x,3.45,0.7,1.05,0)
qDTGIW(p,3.45,0.7,1.05,0)

}
\references{
Atchanut Rattanalertnusorn and Sirinapa Aryuyuen (2021).
The zero-truncated discrete transmuted generalized inverse Weibull distribution and its applications,
Songklanakarin Journal of Science and Technology (SJST), Volume 43 No.4 (July - August 2021), pp. 1140 - 1151. DOI: 10.14456/sjst-psu.2021.149.
}
