% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtlcor_fun.R
\name{dtl_get_alpha_s_sim}
\alias{dtl_get_alpha_s_sim}
\title{Numerical significance level given a fixed correlation coefficient for the
final stage under drop-the-losers (DTL) design}
\usage{
dtl_get_alpha_s_sim(
  nsim = 1e+05,
  n,
  t,
  rho,
  q,
  alpha,
  sel_g_func = sel_g_func_default,
  ...
)
}
\arguments{
\item{nsim}{Number of replicates}

\item{n}{Sample size per arm at DTL look}

\item{t}{A vector of information fraction of final stage}

\item{rho}{Fixed correlation coefficient}

\item{q}{Response rate under the null}

\item{alpha}{A pre-specified FWER}

\item{sel_g_func}{Arm-select function. The default function is
sel_g_func_default(W_2, W_1, delta). Users can define
their own arm-select function. The format of
the function must be function_name(W_2, W_1, ...). The
return values must be 1 (arm 1 is selected) or 2 (arm 2
is selected) or 0 (stop for futility).}

\item{...}{Other arguments from sel_g_func.}
}
\value{
Significance level alpha_s for the final stage
}
\description{
Get the numerical significant level alpha_s based on a pre-specified FWER alpha
given a fixed correlation coefficient for the final stage by simulation
(reverse calculation of dtl_tier_sim())
}
\examples{
\donttest{
# Without interim analysis
dtl_get_alpha_s_sim(nsim = 100000, n = 80, t = 1, rho = 0.4, q = 0.3, 
                    alpha = 0.025, delta = 0.05)
}

}
