% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtrackr.R
\name{p_intersect}
\alias{p_intersect}
\title{Set operations}
\usage{
p_intersect(
  x,
  y,
  ...,
  .messages = "{.count.out} in intersection",
  .headline = "Intersection"
)
}
\arguments{
\item{x, y}{Vectors to combine.}

\item{...}{a collection of tracked data frames to combine}

\item{.messages}{a set of glue specs. The glue code can use any global
variable, or \{.count.out\}}

\item{.headline}{a glue spec. The glue code can use any global variable, or
\{.count.out\}}
}
\value{
the dplyr output with the history graph updated.
}
\description{
These perform set operations on tracked dataframes. It merges the history
of 2 (or more) dataframes and combines the rows (or columns). It calculates the total number of
resulting rows as \{.count.out\} in other terms it performs exactly the same
operation as the equivalent \code{dplyr} operation. See \code{\link[dplyr:bind_rows]{dplyr::bind_rows()}},
\code{\link[dplyr:bind_cols]{dplyr::bind_cols()}}, \code{\link[dplyr:setops]{dplyr::intersect()}}, \code{\link[dplyr:setops]{dplyr::union()}},
\code{\link[dplyr:setops]{dplyr::setdiff()}},\code{\link[dplyr:setops]{dplyr::intersect()}}, or \code{\link[dplyr:setops]{dplyr::union_all()}} for the
underlying function details.
}
\examples{
library(dplyr)
library(dtrackr)

# Set operations
people = starwars \%>\% select(-films, -vehicles, -starships)
chrs = people \%>\% track("start")

lhs = chrs \%>\% include_any(
  species == "Human" ~ "{.included} humans",
  species == "Droid" ~ "{.included} droids"
)

# these are different subsets of the same data
rhs = chrs \%>\% include_any(
  species == "Human" ~ "{.included} humans",
  species == "Gungan" ~ "{.included} gungans"
) \%>\% comment("{.count} gungans & humans")


# Unions
set = bind_rows(lhs,rhs) \%>\% comment("{.count} 2*human,droids and gungans")
# display the history of the result:
set \%>\% history()
nrow(set)
# not run - display the flowchart:
# set \%>\% flowchart()

set = union(lhs,rhs) \%>\% comment("{.count} human,droids and gungans")
# display the history of the result:
set \%>\% history()
nrow(set)
# not run - display the flowchart:
# set \%>\% flowchart()

set = union_all(lhs,rhs) \%>\% comment("{.count} 2*human,droids and gungans")
# display the history of the result:
set \%>\% history()
nrow(set)
# not run - display the flowchart:
# set \%>\% flowchart()

# Intersections and differences

set = setdiff(lhs,rhs) \%>\% comment("{.count} droids and gungans")
# display the history of the result:
set \%>\% history()
nrow(set)
# not run - display the flowchart:
# set \%>\% flowchart()

set = intersect(lhs,rhs) \%>\% comment("{.count} humans")
# display the history of the result:
set \%>\% history()
nrow(set)
# not run - display the flowchart:
# set \%>\% flowchart()
}
\seealso{
\code{\link[generics:setops]{generics::intersect()}}
}
