% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S4-DistmatLowerTriangular.R
\docType{class}
\name{DistmatLowerTriangular-class}
\alias{DistmatLowerTriangular-class}
\alias{DistmatLowerTriangular}
\title{Distance matrix's lower triangular}
\description{
Reference class that is used internally for PAM centroids when \code{pam.precompute = TRUE} and
\code{pam.sparse = FALSE}. It contains \linkS4class{Distmat}.
}
\details{
If you wish to, you can use this class to access \code{dist} elements with \code{[} as if it were a normal
matrix. You can use \link[methods:new]{methods::new} passing the \code{dist} object in a \code{distmat} argument.
}
\section{Fields}{

\describe{
\item{\code{distmat}}{The lower triangular.}
}}

\section{Methods}{

\describe{
\item{\code{initialize(..., distmat, series, distance, control, error.check = TRUE)}}{Initialization based on needed parameters}
}}

\examples{

dm <- new("DistmatLowerTriangular",
          distmat = proxy::dist(CharTraj[1:5], method = "gak", sigma = 5.5, window.size = 10L))

dm[2:3, 4:5]

}
