% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter.R
\name{get_log}
\alias{get_log}
\alias{get_log.data.frame}
\alias{get_log.list}
\title{Get Log}
\usage{
get_log(data, incl, incl.adsl)

\method{get_log}{data.frame}(data, incl = TRUE, incl.adsl = TRUE)

\method{get_log}{list}(data, incl = TRUE, incl.adsl = TRUE)
}
\arguments{
\item{data}{(\code{list} of \code{data.frame} or \code{data.frame}) filtered with \code{log_filter}.}

\item{incl}{(\code{flag}) should information about unfiltered \code{data.frame} be printed.}

\item{incl.adsl}{(\code{flag}) should indication  of filtering performed through \code{adsl} be printed.}
}
\value{
\code{character} or \verb{list of character} describing the filtering applied to \code{data}.
}
\description{
Get Log
}
\examples{
data <- log_filter(iris, Sepal.Length >= 7, "xx")
data <- log_filter(data, Sepal.Length < 2)
data <- log_filter(data, Sepal.Length >= 2, "yy")
get_log(data)

data <- log_filter(
  list(iris1 = iris, iris2 = iris),
  Sepal.Length >= 7,
  "iris1",
  character(0),
  "Sep"
)
get_log(data)

}
