# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Maximum of Numeric Values
#' 
#' Written in C++, this function tends to run faster than \code{max} for large 
#' numeric vectors/matrices.
#' 
#' @param x Numeric vector.
#' 
#' @return Numeric value.
#' 
#' @examples
#' # For large objects, max_n is faster than max
#' x <- rnorm(100000)
#' max(x) == max_n(x)
#' benchmark(max(x), max_n(x), replications = 1000)
#' 
#' # For smaller objects, max_n is slower than max
#' x <- rnorm(100)
#' max(x) == max_n(x)
#' benchmark(max(x), max_n(x), replications = 1000)
#' 
#' @export
max_n <- function(x) {
    .Call(`_dvmisc_max_n`, x)
}

#' Mean of Integer Values
#' 
#' Written in C++, this function runs faster than \code{\link[base]{mean}} for 
#' large integer vectors/matrices.
#' 
#' @param x Integer vector or matrix.
#' 
#' @return Numeric value.
#' 
#' @examples
#' # For very large integer objects, sum_i is faster than sum
#' x <- rpois(100000, lambda = 5)
#' mean(x) == mean_i(x)
#' benchmark(mean(x), mean_i(x), replications = 1000)
#' 
#' # For smaller integer objects, sum_i is slower than sum 
#' x <- rpois(1000, lambda = 5)
#' mean(x) == mean_i(x)
#' benchmark(mean(x), mean_i(x), replications = 1000)
#' 
#' @export
mean_i <- function(x) {
    .Call(`_dvmisc_mean_i`, x)
}

#' Minimum of Numeric Values
#' 
#' Written in C++, this function tends to run faster than \code{min} for large 
#' numeric vectors/matrices.
#' 
#' @param x Numeric vector.
#' 
#' @return Numeric value.
#' 
#' @examples
#' # For large objects, min_n is faster than min
#' x <- rnorm(100000)
#' min(x) == min_n(x)
#' benchmark(min(x), min_n(x), replications = 1000)
#' 
#' # For smaller objects, min_n is slower than min
#' x <- rnorm(100)
#' min(x) == min_n(x)
#' benchmark(min(x), min_n(x), replications = 20000)
#' 
#' @export
min_n <- function(x) {
    .Call(`_dvmisc_min_n`, x)
}

moving_mean_i <- function(x, window) {
    .Call(`_dvmisc_moving_mean_i`, x, window)
}

moving_mean_i_max <- function(x, window) {
    .Call(`_dvmisc_moving_mean_i_max`, x, window)
}

moving_mean_n <- function(x, window) {
    .Call(`_dvmisc_moving_mean_n`, x, window)
}

moving_mean_n_max <- function(x, window) {
    .Call(`_dvmisc_moving_mean_n_max`, x, window)
}

sliding_cor_c <- function(shortvec, longvec, sd_shortvec) {
    .Call(`_dvmisc_sliding_cor_c`, shortvec, longvec, sd_shortvec)
}

sliding_cov_c <- function(shortvec, longvec) {
    .Call(`_dvmisc_sliding_cov_c`, shortvec, longvec)
}

#' Sum of Integer Values
#' 
#' Written in C++, this function runs faster than \code{\link[base]{sum}} for 
#' large integer vectors/matrices.
#' 
#' @param x Integer vector or matrix.
#' 
#' @return Numeric value.
#' 
#' @examples
#' # For very large integer objects, sum_i is faster than sum
#' x <- rpois(100000, lambda = 5)
#' sum(x) == sum_i(x)
#' benchmark(sum(x), sum_i(x), replications = 1000)
#' 
#' # For smaller integer objects, sum_i is slower than sum 
#' x <- rpois(1000, lambda = 5)
#' sum(x) == sum_i(x)
#' benchmark(sum(x), sum_i(x), replications = 1000)
#' 
#' @export
sum_i <- function(x) {
    .Call(`_dvmisc_sum_i`, x)
}

truerange_i <- function(x) {
    .Call(`_dvmisc_truerange_i`, x)
}

truerange_n <- function(x) {
    .Call(`_dvmisc_truerange_n`, x)
}

#' Return (Row, Column) Index of (First) Maximum of an Integer Matrix
#' 
#' Written in C++, this function tends to run much faster than the equivalent 
#' (if maximum is unique) base R solution 
#' \code{which(x == max(x), arr.ind = TRUE)}.
#' 
#' For optimal speed, choose the version of this function that matches the 
#' class of your \code{x}:
#' 
#' \code{\link{which_max_nv}} for numeric vector. \cr
#' \code{\link{which_max_iv}} for integer vector. \cr
#' \code{\link{which_max_nm}} for numeric matrix. \cr
#' \code{\link{which_max_im}} for integer matrix.
#' 
#' @param x Integer matrix.
#' 
#' @return Integer vector.
#' 
#' @examples 
#' # which_max_im is typically much faster than 
#' # which(x == max(x), arr.ind = TRUE)
#' x <- matrix(rpois(100, lambda = 15), ncol = 10)
#' all(which(x == max(x), arr.ind = TRUE) == which_max_im(x))
#' benchmark(which(x == max(x), arr.ind = TRUE), which_max_im(x), 
#'           replications = 5000)
#' 
#' @export
which_max_im <- function(x) {
    .Call(`_dvmisc_which_max_im`, x)
}

#' Return Index of (First) Maximum of an Integer Vector
#' 
#' Written in C++, this function tends to run faster than \code{which.max} for 
#' large integer vectors.
#' 
#' For optimal speed, choose the version of this function that matches the 
#' class of your \code{x}:
#' 
#' \code{\link{which_max_nv}} for numeric vector. \cr
#' \code{\link{which_max_iv}} for integer vector. \cr
#' \code{\link{which_max_nm}} for numeric matrix. \cr
#' \code{\link{which_max_im}} for integer matrix.
#' 
#' @param x Integer vector.
#' 
#' @return Integer value.
#' 
#' @examples 
#' # For long vectors, which_max_iv is faster than which.max
#' x <- rpois(10000, lambda = 15)
#' which.max(x) == which_max_iv(x)
#' benchmark(which.max(x), which_max_iv(x), replications = 5000)
#' 
#' # For shorter vectors, which_max_iv is slower than which.max
#' x <- rpois(100, lambda = 15)
#' which.max(x) == which_max_iv(x)
#' benchmark(which.max(x), which_max_iv(x), replications = 20000)
#' 
#' @export
which_max_iv <- function(x) {
    .Call(`_dvmisc_which_max_iv`, x)
}

#'Return (Row, Column) Index of (First) Maximum of a Numeric Matrix
#' 
#' Written in C++, this function tends to run much faster than the equivalent 
#' (if maximum is unique) base R solution 
#' \code{which(x == max(x), arr.ind = TRUE)}.
#' 
#' For optimal speed, choose the version of this function that matches the 
#' class of your \code{x}:
#' 
#' \code{\link{which_max_nv}} for numeric vector. \cr
#' \code{\link{which_max_iv}} for integer vector. \cr
#' \code{\link{which_max_nm}} for numeric matrix. \cr
#' \code{\link{which_max_im}} for integer matrix.
#' 
#' @param x Numeric matrix.
#' 
#' @return Integer vector.
#' 
#' @examples 
#' # which_max_nm is typically much faster than 
#' # which(x == max(x), arr.ind = TRUE)
#' x <- matrix(rnorm(100), ncol = 10)
#' all(which(x == max(x), arr.ind = TRUE) == which_max_nm(x))
#' benchmark(which(x == max(x), arr.ind = TRUE), which_max_nm(x),
#'           replications = 5000)
#' 
#' @export
which_max_nm <- function(x) {
    .Call(`_dvmisc_which_max_nm`, x)
}

#' Return Index of (First) Maximum of a Numeric Vector
#' 
#' Written in C++, this function tends to run faster than \code{which.max} for 
#' large numeric vectors.
#' 
#' For optimal speed, choose the version of this function that matches the 
#' class of your \code{x}:
#' 
#' \code{\link{which_max_nv}} for numeric vector. \cr
#' \code{\link{which_max_iv}} for integer vector. \cr
#' \code{\link{which_max_nm}} for numeric matrix. \cr
#' \code{\link{which_max_im}} for integer matrix.
#' 
#' @param x Numeric vector.
#' 
#' @return Integer value.
#' 
#' @examples 
#' # For long vectors, which_max_nv is faster than which.max
#' x <- rnorm(100000)
#' which.max(x) == which_max_nv(x)
#' benchmark(which.max(x), which_max_nv(x), replications = 500)
#' 
#' # For shorter vectors, which_max_nv is slower than which.max
#' x <- rnorm(100)
#' which.max(x) == which_max_nv(x)
#' benchmark(which.max(x), which_max_nv(x), replications = 10000)
#' 
#' @export
which_max_nv <- function(x) {
    .Call(`_dvmisc_which_max_nv`, x)
}

#' Return (Row, Column) Index of (First) Minimum of an Integer Matrix
#' 
#' Written in C++, this function tends to run much faster than the equivalent 
#' (if minimum is unique) base R solution 
#' \code{which(x == min(x), arr.ind = TRUE)}.
#' 
#' For optimal speed, choose the version of this function that matches the 
#' class of your \code{x}:
#' 
#' \code{\link{which_min_nv}} for numeric vector. \cr
#' \code{\link{which_min_iv}} for integer vector. \cr
#' \code{\link{which_min_nm}} for numeric matrix. \cr
#' \code{\link{which_min_im}} for integer matrix.
#' 
#' @param x Integer matrix.
#' 
#' @return Integer vector.
#' 
#' @examples 
#' # which_min_im is typically much faster than 
#' # which(x == min(x), arr.ind = TRUE)
#' x <- matrix(rpois(100, lambda = 10), ncol = 10)
#' all(which(x == min(x), arr.ind = TRUE) == which_min_im(x))
#' benchmark(which(x == min(x), arr.ind = TRUE), which_min_im(x),
#'           replications = 5000)
#' 
#' @export
which_min_im <- function(x) {
    .Call(`_dvmisc_which_min_im`, x)
}

#' Return Index of (First) Minimum of an Integer Vector
#' 
#' Written in C++, this function tends to run faster than 
#' \code{\link{which.min}} for large integer vectors.
#' 
#' For optimal speed, choose the version of this function that matches the 
#' class of your \code{x}:
#' 
#' \code{\link{which_min_nv}} for numeric vector. \cr
#' \code{\link{which_min_iv}} for integer vector. \cr
#' \code{\link{which_min_nm}} for numeric matrix. \cr
#' \code{\link{which_min_im}} for integer matrix.
#' 
#' @param x Integer vector.
#' 
#' @return Integer value.
#' 
#' @examples 
#' # For long vectors, which_min_iv is faster than which.min 
#' x <- rpois(10000, lambda = 15)
#' which.min(x) == which_min_iv(x)
#' benchmark(which.min(x), which_min_iv(x), replications = 5000)
#' 
#' # For shorter vectors, which_min_iv is slower than which.min
#' x <- rpois(100, lambda = 15)
#' which.min(x) == which_min_iv(x)
#' benchmark(which.min(x), which_min_iv(x), replications = 20000)
#' 
#' @export
which_min_iv <- function(x) {
    .Call(`_dvmisc_which_min_iv`, x)
}

#' Return (Row, Column) Index of (First) Minimum of a Numeric Matrix
#' 
#' Written in C++, this function tends to run much faster than the equivalent 
#' (if minimum is unique) base R solution 
#' \code{which(x == min(x), arr.ind = TRUE)}.
#' 
#' For optimal speed, choose the version of this function that matches the 
#' class of your \code{x}:
#' 
#' \code{\link{which_min_nv}} for numeric vector. \cr
#' \code{\link{which_min_iv}} for integer vector. \cr
#' \code{\link{which_min_nm}} for numeric matrix. \cr
#' \code{\link{which_min_im}} for integer matrix.
#' 
#' @param x Numeric matrix.
#' 
#' @return Integer vector.
#' 
#' @examples 
#' # which_min_nm is typically much faster than 
#' # which(x == min(x), arr.ind = TRUE)
#' x <- matrix(rnorm(100), ncol = 10)
#' all(which(x == min(x), arr.ind = TRUE) == which_min_nm(x))
#' benchmark(which(x == min(x), arr.ind = TRUE), which_min_nm(x), 
#'           replications = 5000)
#' 
#' @export
which_min_nm <- function(x) {
    .Call(`_dvmisc_which_min_nm`, x)
}

#' Return Index of (First) Minimum of a Numeric Vector
#' 
#' Written in C++, this function tends to run faster than 
#' \code{\link[base]{which.min}} for large numeric vectors.
#' 
#' For optimal speed, choose the version of this function that matches the 
#' class of your \code{x}:
#' 
#' \code{\link{which_min_nv}} for numeric vector. \cr
#' \code{\link{which_min_iv}} for integer vector. \cr
#' \code{\link{which_min_nm}} for numeric matrix. \cr
#' \code{\link{which_min_im}} for integer matrix.
#' 
#' @param x Numeric vector.
#' 
#' @return Integer value.
#' 
#' @examples 
#' # For long vectors, which_min_nv is faster than which.min
#' x <- rnorm(100000)
#' which.min(x) == which_min_nv(x)
#' benchmark(which.min(x), which_min_nv(x), replications = 1000)
#' 
#' # For shorter vectors, which_min_nv is slower than which.min
#' x <- rnorm(100)
#' which.min(x) == which_min_nv(x)
#' benchmark(which.min(x), which_min_nv(x), replications = 10000)
#' 
#' @export
which_min_nv <- function(x) {
    .Call(`_dvmisc_which_min_nv`, x)
}

