% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taper.R
\name{taper}
\alias{taper}
\title{Tree taper (or profile) equation.}
\usage{
taper(h, H, D, b, bh, area = FALSE)
}
\arguments{
\item{h}{Height level(s), possibly a vector.}

\item{H}{Tree total height.}

\item{D}{Tree diameter at breast height (dbh).}

\item{b}{Vector with the 5 parameters.}

\item{bh}{Breast height. Typically 1.2, 1.3 or 1.4 m, or 4.5 ft.}

\item{area}{If TRUE, returns cross-sectional areas, otherwise returns
diameters. Default is FALSE.}
}
\value{
Diameter(s) at level(s) '\code{h}' if '\code{area}' is FALSE,
           otherwise cross-sectional area(s).
}
\description{
Returns the diameter or cross-sectional area at one or more hight levels.
}
\note{
Diameters or areas are either all outside bark, or all inside bark.
  A dbh outside bark can be used with an inside-bark taper equation through
  a substitution \code{D -> k * D}, where \code{k} is an outside to inside
   bark conversion factor.
}
\examples{
  curve(taper(x, 32, 0.956*24, c(2.569, 0, 1.042, 0.3012, -1), 1.3), 0, 32)

}
