% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotGrid.R
\name{plotGrid}
\alias{plotGrid}
\title{Grid of Diffusion Profiles}
\usage{
plotGrid(filename)
}
\arguments{
\item{filename}{Name of the file that contains the results of a simulated electrochemistry experiment.}
}
\value{
Returns a 3 by 3 grid of individual plots.
}
\description{
Plots eight diffusion profiles---at times that are 10%, 20%,
30%, 40%, 60%, 70%, 80%, and 90% of the total time for the
experiment---around a central plot that shows the
corresponding voltammogram, chronoamperogram, or
chronocoulogram using an object created with one of the
package's simulation functions: \code{cvSim} for cyclic
voltammetry, \code{lsvSim} for linear sweep voltammetry,
\code{caSim} for chronoamperometry, or \code{ccSim} for
chronocoulometry. Note: this function will not work with the
reduced data file created using \code{sampleAmpgram},
\code{sampleCoulgram}, or \code{sampleVoltgram}.
}
\examples{

ex_cv = simulateCV(e.start = 0.25, e.switch = -0.25, e.form = 0,
  x.units = 100, t.units = 1000)
plotGrid(ex_cv)

ex_ca = simulateCA(e.start = 0.25, e.pulse = -0.25, e.form = 0,
  pulses = "double", t.2 = 20, x.units = 100, t.units = 1000)
plotGrid(ex_ca)
}
