% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eDNA_index.r
\name{eDNAindex}
\alias{eDNAindex}
\title{Create scaled relative proportions of the number of reads of taxa in different samples}
\usage{
eDNAindex(
  tibble,
  Sample_column = Sample,
  OTU_column = Hash,
  Counts_column = nReads,
  Biological_replicate_column = NULL,
  ...
)
}
\arguments{
\item{tibble}{A tibble the ASV table in a long format, with at least three columns, Sample_column, OTU_column, Counts_column}

\item{Sample_column}{The column indicating the sample.}

\item{OTU_column}{The column indicating the OTU/ASV.}

\item{Counts_column}{The column (numeric) with the number of sequences from that OTU in that sample.}

\item{Biological_replicate_column}{The column representing replicate measurements of Sample_column.}

\item{...}{Any extra columns that want to be added to the final dataset (either taxonomical information about OTUs, or metadata information about the samples)}
}
\value{
A tibble with at least the columns Sample_column, OTU_column and Normalized.reads
}
\description{
This function takes a long ASV table (tibble) and creates a new column with the relative proportions scaled to their maximum,
to avoid the dominance of species with better primer efficiency
}
\examples{
data("training.ASV.table")
eDNAindex(training.ASV.table, Sample_column = Sample_name)

}
