% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phyloseq_tidy.R
\name{tidy2phyloseq}
\alias{tidy2phyloseq}
\alias{phyloseq2tidy}
\title{Convert a tidy ASV table to a phyloseq object}
\usage{
tidy2phyloseq(
  ASV_table,
  OTU_taxonomy = NULL,
  metadata = NULL,
  Taxa = "sseqid",
  Sample = "sample_name",
  Reads = "nr",
  tree = NULL
)

phyloseq2tidy(phylo_obj, Taxa = "sseqid", Sample = "sample_name", Reads = "nr")
}
\arguments{
\item{ASV_table}{A tidy data.frame/tibble of ASV counts.}

\item{OTU_taxonomy}{A data.frame with OTU taxonomy. Optional.}

\item{metadata}{A data.frame with sample metadata. Optional.}

\item{Taxa}{Column name for OTU IDs in the output (default: "sseqid").}

\item{Sample}{Column name for sample IDs in the output (default: "sample_name").}

\item{Reads}{Column name for read counts in the output (default: "nr").}

\item{tree}{A phylogenetic tree of class `phylo`. Optional.}

\item{phylo_obj}{A phyloseq object.}
}
\value{
A `phyloseq` object combining OTU table, taxonomy, metadata, and optionally a tree.

A list with three tibbles:
\describe{
  \item{ASV_table}{Long-format tibble of counts: Sample, Taxa, Reads.}
  \item{taxonomy}{Taxonomy table as tibble (NULL if none in phyloseq).}
  \item{metadata}{Sample metadata as tibble (NULL if none in phyloseq).}
}
}
\description{
This function converts a tidy ASV table, along with optional taxonomy and metadata,
into a `phyloseq` object.

Extracts ASV counts, taxonomy, and metadata from a `phyloseq` object into tidy data frames.
}
\examples{
data("ASV_table")
data("metadata")
data("OTU_taxonomy")
ps <- tidy2phyloseq(ASV_table = ASV_table,
                    OTU_taxonomy = OTU_taxonomy,
                    metadata = metadata,
                    Taxa = "Hash",
                    Reads = "nReads")


data("ps")
tidy_list <- phyloseq2tidy(ps)


}
