% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QC_clean.R
\name{ordinal_label_levels}
\alias{ordinal_label_levels}
\title{Extract labels and levels of ordinal variables in a dataset}
\usage{
ordinal_label_levels(data, out_path = NULL)
}
\arguments{
\item{data}{data frame with ordinal variables with labels and levels to be
extracted.}

\item{out_path}{Optional string. Path to write output to. If not supplied, \R
object will be returned.}
}
\value{
Tibble of text label and (numerical) level mappings
}
\description{
This function enables preservation of the text labels for ordinal variables in
 a dataset in preparation for conversion to a numeric matrix. A table is produced
 which retains the mappings between the text labels and the
numerical labels for future reference.
}
\examples{
require(magrittr)  # for \%>\%

# create an example class_tbl object
# note that diabetes_type is classed as ordinal yet is not modified as its
# levels are not pre-coded. It should instead be encoded with encode_ordinals().
tibble::tribble(~"var", ~"datatype",
"patient_id", "id",
"tumoursize", "numeric",
"t_stage", "ordinal_tstage",
"n_stage", "ordinal_nstage",
"diabetes", "factor",
"diabetes_type", "ordinal",
"hypertension", "factor",
"rural_urban", "factor",
"marital_status", "factor",
"SNP_a", "genotype",
"SNP_b", "genotype",
"free_text", "freetext") -> data_types

# show unqiue values for t_stage in pre-QC example_data 
unique(example_data$t_stage)

# apply quality control to example_data
apply_quality_ctrl(example_data, patient_id, data_types,
bin_cats =c("No" = "Yes", "rural" = "urban"),  min_freq = 0.6) \%>\%
ordinal_label_levels -> res

# examine the labels and levels of t_stage in post-QC example_data
dplyr::filter(res, variable == "t_stage")

}
