% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epm_all_fx.R
\name{epm_parse_record}
\alias{epm_parse_record}
\title{Extract Information from a Raw PubMed Record.}
\usage{
epm_parse_record(
  pubmedArticle,
  max_authors = 15,
  autofill_address = TRUE,
  compact_output = TRUE,
  include_abstract = TRUE,
  max_references = 1000,
  ref_id_type = "pmid"
)
}
\arguments{
\item{pubmedArticle}{String, this is an XML-tag-decorated raw PubMed record.}

\item{max_authors}{Numeric, maximum number of authors to retrieve. If this
is set to -1, only the last author is extracted. If this is set to 1, 
only the first author is returned. If this is set to 2, the first and the 
last authors are extracted. If this is set to any other positive 
number (i), up to the leading (n-1) authors are retrieved together with the 
last author. If this is set to a number larger than the number of authors in
a record, all authors are returned. Note that at least 1 author has to be
retrieved, therefore a value of 0 is not accepted (coerced to -1).}

\item{autofill_address}{Logical, shall author affiliations be 
propagated within each record to fill missing values.}

\item{compact_output}{Logical, shall record data be returned in a 
compact format where each row is a single record and author names are
collapsed together. If `FALSE`, each row corresponds to a single author of
the publication and the record-specific data are recycled for all included
authors.}

\item{include_abstract}{Logical, shall abstract text be included in the 
output data.frame. If `FALSE`, the abstract text column is populated 
with a missing value.}

\item{max_references}{Numeric, maximum number of references to return (for
each PubMed record).}

\item{ref_id_type}{String, must be one of the
following values: `c('pmid', 'doi')`. Type of identifier used to describe 
citation references.}
}
\value{
a data.frame including information extracted from a 
raw XML PubMed record.
}
\description{
Read a raw PubMed record, identify XML tags, extract information 
and cast it into a structured `data.frame`. The expected input is
an XML-tag-decorated string corresponding to a single PubMed
record. Information about article title, authors, affiliations, 
journal name and abbreviation, publication date, references, and
keywords are returned.
}
\examples{
data(epm_samples)
x <- epm_samples$bladder_cancer_2018$demo_data_03$raw[[1]]
epm_parse_record(x)




}
\references{
\url{https://www.data-pulse.com/dev_site/easypubmed/}
}
\author{
Damiano Fantini, \email{damiano.fantini@gmail.com}
}
