% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ellipse.R
\name{ellipse.svg}
\alias{ellipse.svg}
\title{Generate ellipse SVG element}
\usage{
ellipse.svg(cx = NULL, cy = NULL, rx = NULL, ry = NULL, fill,
  fill.opacity, stroke, stroke.width, stroke.opacity, stroke.dasharray,
  style.sheet = NULL)
}
\arguments{
\item{cx}{a number, x coordinate information}

\item{cy}{a number, y corrdinate information}

\item{rx}{a number, x radius of the ellipse}

\item{ry}{a number, y radius of the ellipse}

\item{fill}{a character, color of the ellipse, eg. "#000000"(default), "red"}

\item{fill.opacity}{a number, stroke opacity of the ellipse, default:1. If the fill opacity is 0, the ellipse's internal color is invisible}

\item{stroke}{a characher, color of the ellipse line, eg. "#000000"(default), "red"}

\item{stroke.width}{a number, stroke width of the ellipse line, default: 1}

\item{stroke.opacity}{a number, stroke opacity of the ellipse line, default:1. If the stroke opacity is 0, the line is invisible}

\item{stroke.dasharray}{a vector, plot the dotted ellipse line, eg. c(9, 5)}

\item{style.sheet}{a vector or a chatacter, other style of the ellipse, eg. "stroke-linecap: round"}
}
\value{
the characher type of SVG element
}
\description{
This function can generate a ellipse form of SVG element
The ellipse element is an SVG basic shape, used to create ellipses
based on a center coordinate, and both their x and y radius.
}
\examples{
ellipse.svg(cx = 10, cy = 20, rx = 10, ry = 5, fill = "blue")
ellipse.svg(cx = 10, cy = 20, rx = 10, ry = 5, fill = "blue", stroke.width = 2)

}
