% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/easyDB.R
\name{easydb_disconnect}
\alias{easydb_disconnect}
\title{Disconnect from database}
\usage{
easydb_disconnect(connection)
}
\arguments{
\item{connection}{coneection generated by [easydb_connect]}
}
\value{
Invisibly returns TRUE
}
\description{
Simple wrapper around [DBI::dbDisconnect()]
}
\examples{
if(interactive()) {

  # Choose config file path
  # Do NOT use tempfile in practice.
  # Instead, choose a fixed location such as '~/.easydb'
  config <- tempfile('.example_config')

  # Initialise config file
  easydb_init(config)

  # Connect to SQLite database
  path_to_db <- system.file(package = 'easydb', 'testdbs/mtcars.sqlite')
  con <- easydb_connect(dbname = path_to_db, config_file = config)

  # Disconnect from database when finished
  easydb_disconnect(con)
}
}
