% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.fit_models}
\alias{plot.fit_models}
\title{Plot method for \code{fit_models}}
\usage{
\method{plot}{fit_models}(
  x,
  eval_time = NULL,
  km_include = TRUE,
  subtitle_include = TRUE,
  add_plotly = FALSE,
  ...
)
}
\arguments{
\item{x}{An object of class \code{fit_models}}

\item{eval_time}{Time points at which to evaluate the survival function.
Default is \code{NULL}.}

\item{km_include}{Logical value indicating whether to include Kaplan-Meier
survival data. Default is \code{TRUE}.}

\item{subtitle_include}{Logical value indicating whether to include a
subtitle in the plot. Default is \code{TRUE}.}

\item{add_plotly}{Logical value indicating whether to add plotly
interactivity. Default is \code{FALSE}.}

\item{...}{Additional arguments}
}
\value{
A list containing predictions and plots for the survival and hazards
of models in a \code{fit_models} object.
}
\description{
Plot method for \code{fit_models}
}
\examples{
models <- fit_models(
  data = easysurv::easy_bc,
  time = "recyrs",
  event = "censrec",
  predict_by = "group",
  covariates = "group"
)

plot(models)
}
