% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/est_mixture.R
\name{est_mixture}
\alias{est_mixture}
\title{Estimate Parameters in a Two-Component Gaussian Mixture Using Study-Level Summaries}
\usage{
est_mixture(ni, xbar, mi, s2 = NULL, method = c("gmm", "naive"))
}
\arguments{
\item{ni}{Integer vector of sample sizes per study.}

\item{xbar}{Numeric vector of sample means per study.}

\item{mi}{Integer vector of group 1 counts per study.}

\item{s2}{Numeric vector of sample variances per study. Required if \code{method = "gmm"}.}

\item{method}{Estimation method to use. One of \code{"naive"} or \code{"gmm"}. Default is \code{"gmm"}.}
}
\value{
A named list containing:
\describe{
  \item{\code{mu1_hat, mu0_hat}}{Estimated means of the two groups.}
  \item{\code{sigma1_hat, sigma0_hat}}{Estimated standard deviations.}
  \item{\code{se}}{Standard errors of the parameter estimates (NA if \code{method = "naive"}).}
  \item{\code{ci}}{List of 95\% confidence intervals for each parameter (NULL if \code{method = "naive"}).}
  \item{\code{method}}{A character string indicating the method used.}
}
}
\description{
Estimates group-specific means and standard deviations \eqn{(\mu_1, \mu_0, \sigma_1, \sigma_0)} in a two-component
normal mixture model based on aggregate data across multiple studies. The continuous variable \eqn{X}
is assumed to follow a Gaussian mixture conditional on a binary group indicator \eqn{Y \in \{0,1\}},
with each study reporting only summary-level statistics.
}
\details{
#' Two estimation methods are available:
\itemize{
  \item \strong{"naive"}: Likelihood-based estimator using only sample means.
  \item \strong{"gmm"}: Generalized method of moments (GMM) estimator using sample means and variances.
}
}
\examples{
# Load example dataset included in the package
data(mixture_example)

# Estimate using GMM (recommended) with full summary statistics
est_mixture(
  ni = mixture_example$ni,
  xbar = mixture_example$xbar,
  s2 = mixture_example$s2,
  mi = mixture_example$mi,
  method = "gmm"
)

# Estimate using naive likelihood method (only means used)
est_mixture(
  ni = mixture_example$ni,
  xbar = mixture_example$xbar,
  mi = mixture_example$mi,
  method = "naive"
)

}
