% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/probtrans_ebmstate.R
\name{probtrans_ebmstate}
\alias{probtrans_ebmstate}
\title{Compute subject-specific transition probabilities
using convolution.}
\usage{
probtrans_ebmstate(
  initial_state,
  cumhaz,
  model,
  max_time = NULL,
  nr_steps = 10000
)
}
\arguments{
\item{initial_state}{The present function 
estimates transition probabilities from the state given
in this argument.}

\item{cumhaz}{An \code{msfit} object created by running
\code{mstate} or \code{mstate_generic}.}

\item{model}{Either 'clockforward' or
'clockreset'. See details.}

\item{max_time}{The maximum time for which transition probabilities
are estimated.}

\item{nr_steps}{The number of steps in the convolution algorithm
(larger increases precision but makes it slower)}
}
\value{
An object of class 'probtrans'. See the 'value' 
section in the help page of \code{mstate::probtrans}.
}
\description{
Compute subject-specific transition probabilities
using convolution.
}
\details{
The clock-forward model is a model 
in which the transition hazard rates depend only on
time since the initiating event. The clock-reset model
has a single time scale: the sojourn time in the current 
state.

The algorithm behind \code{probtrans_ebmstate} is based 
on the convolution of density and survival functions and
is suitable for processes with a tree-like transition
structure only.
}
\examples{
\donttest{
# Compute transition probabilities
# from an object with (pre-estimated) 
# cumulative hazard rates.

#load object with estimated
#cumulative hazard rates 
data("msfit_object_sample")

#compute transition probabilities
probtrans_object<-probtrans_ebmstate("health",
   msfit_object_sample,"clockforward")
}
}
\seealso{
\code{\link[mstate]{probtrans}};
}
\author{
Rui Costa & Moritz Gerstung
}
