% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Hutcheson_t_test.R
\name{Hutcheson_t_test}
\alias{Hutcheson_t_test}
\title{Hutcheson's t-test for two diversity indices.}
\usage{
Hutcheson_t_test(
  x,
  y,
  shannon.base = exp(1),
  alternative = "two.sided",
  difference = 0
)
}
\arguments{
\item{x, y}{Numeric vectors of abundance of species for community sample
\emph{x} and community sample \emph{y}.}

\item{shannon.base}{A numeric value indicating the logarithm base for the
Shannon indices. Defaults to \emph{exp(1)}.}

\item{alternative}{A character indicating the alternative hypothesis.
Can be "two.sided"(default), "less", "greater", or "auto".}

\item{difference}{A numeric value indicating the hypothesized difference
between the diversity indexes. Defaults to 0.}
}
\value{
A list of class "htest" containing the following components:
\itemize{
\item statistic: Value of the Hutcheson t-statistic.
\item parameter: The degrees of freedom of the t-statistic parameter.
\item p.value: The test's p-value.
\item estimate: The Shannon diversity indices of x and y.
\item null.value: The  hypothesized value of the difference between
the Shannon diversty indexes.
\item method: Name of the test.
\item alternative: The alternative hypothesis.
\item data.name: Name of the data used in the test.
}
}
\description{
This function performs Hutcheson's t-test for
significance of the difference between the diversity indices of
two communities.
}
\details{
This function performs Hutcheson's t-test for comparing two
sample's Shannon diversity indices. This test is based on Shannon diversity
indices computed using a logarithm base specified by the user.
One-sided and two-sided tests are available.
}
\note{
Missing values will be replaced with zero values.
}
\examples{
data("polychaeta_abundance")
# two-sided test
Hutcheson_t_test(x=polychaeta_abundance$Sample.1,
                 y=polychaeta_abundance$Sample.2,
                 shannon.base = 10)
# one-sided test
Hutcheson_t_test(x=polychaeta_abundance$Sample.1,
                 y=polychaeta_abundance$Sample.2,
                 shannon.base = 10,
                 alternative = "greater")
}
\references{
Zar, Jerrold H. 2010. Biostatistical Analysis. 5th ed. Pearson.
pp. 174-176.

Hutcheson, Kermit. 1970. A Test for Comparing Diversities Based on
the Shannon Formula. Journal of Theoretical Biology 29: 151-54.
}
\seealso{
See \code{\link[stats]{t.test}} in \pkg{stats} package for
t-test.
}
\author{
David Ramirez Delgado \email{linfocitoth1@gmail.com}.

Hugo Salinas \email{hugosal@comunidad.unam.mx}.
}
