% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PA.EMOA.computeDominanceRanking.R
\name{computeDominanceRanking}
\alias{computeDominanceRanking}
\title{Ranking of approximation sets.}
\usage{
computeDominanceRanking(df, obj.cols)
}
\arguments{
\item{df}{[\code{data.frame}]\cr
Data frame with columns at least \dQuote{prob}, \dQuote{algorithm}, \dQuote{repl} and
column names specified via parameter \code{obj.cols}.}

\item{obj.cols}{[\code{character(>= 2)}]\cr
Column names in \code{df} which store the objective function values.}
}
\value{
[\code{data.frame}] Reduced \code{df} with columns \dQuote{prob}, \dQuote{algorithm}, \dQuote{repl}
  and \dQuote{rank}.
}
\description{
Ranking is performed by merging all approximation sets over all
algorithms and runs per instance. Next, each approximation set \eqn{C} is assigned a
rank which is 1 plus the number of approximation sets that are better than
\eqn{C}. A set \eqn{D} is better than \eqn{C}, if for each point \eqn{x \in C}{x in C} there
exists a point in \eqn{y \in D}{y in D} which weakly dominates \eqn{x}.
Thus, each approximation set is reduced to a number -- its rank. This rank distribution
may act for first comparrison of multi-objecitve stochastic optimizers.
See [1] for more details.
This function makes use of \code{\link[parallelMap]{parallelMap}} to
parallelize the computation of dominance ranks.
}
\note{
Since pairwise non-domination checks are performed over all algorithms and
algorithm runs this function may take some time if the number of problems, algorithms
and/or replications is high.
}
\references{
[1] Knowles, J., Thiele, L., & Zitzler, E. (2006). A Tutorial on the Performance Assessment
of Stochastic Multiobjective Optimizers. Retrieved from https://sop.tik.ee.ethz.ch/KTZ2005a.pdf
}
\seealso{
Other EMOA performance assessment tools: 
\code{\link{approximateNadirPoint}()},
\code{\link{approximateRefPoints}()},
\code{\link{approximateRefSets}()},
\code{\link{emoaIndEps}()},
\code{\link{makeEMOAIndicator}()},
\code{\link{niceCellFormater}()},
\code{\link{normalize}()},
\code{\link{plotDistribution}()},
\code{\link{plotFront}()},
\code{\link{plotScatter2d}()},
\code{\link{plotScatter3d}()},
\code{\link{toLatex}()}
}
\concept{EMOA performance assessment tools}
