% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rxc.R
\docType{data}
\name{ndc_rxc}
\alias{ndc_rxc}
\title{NDC to Rx Condition Crosswalk - Table 10a}
\format{
An object of class \code{tbl_df} (inherits from \code{tbl}, \code{data.frame}) with
12323 rows and 3 columns
\describe{
\item{rxc}{Rx condition number without leading zeroes}
\item{desc}{Rx condition description}
\item{ndc}{NDC that maps to \code{rxc}}
}
}
\source{
Data import and cleaning at:
\url{https://github.com/EeethB/edgedata/tree/main/data-raw}
}
\usage{
ndc_rxc
}
\description{
A dataset containing the NDC to Rx condition mappings.
}
\details{
The NDC system is a unique drug identifier system. But since there are so
many drugs, and they very specific, the HHS-HCC model groups similar drugs
into broader Rx condition categories.
}
\seealso{
Other crosswalks: 
\code{\link{hcpcs_rxc}},
\code{\link{icd_cc}}

Other RXC tables: 
\code{\link{adult_rxc_hcc_inter}},
\code{\link{adult_rxc}},
\code{\link{hcpcs_rxc}},
\code{\link{rxc_hier}}
}
\concept{RXC tables}
\concept{crosswalks}
\keyword{datasets}
