% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indicator_heat_island.R
\name{UHI}
\alias{UHI}
\title{Heat island effect}
\usage{
UHI(
  x,
  SVF,
  green_df = NULL,
  Qql = 6.11,
  Cair = 1007,
  Pair = 1.14,
  Tmax = 30.8,
  Tmin = 20,
  windspeed = 2.77,
  return_raster = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{x}{An 'sf' object with the urban model of your city and a 'land_use' column with categories of urban features.}

\item{SVF}{A 'stars' object representing sky view factor. It can be computed, e.g. with SAGA's
Sky View Factor algorithm and then loaded with stars::read_stars().}

\item{green_df}{A dataframe of categories that are considered as urban green with two columns. 'land_uses'
with the names of 'land_use' in 'x' to be considered as green; a 'pGreen' column with the percentage of green
of that function. If NULL, categories and values of 'city_land_uses' dataset are considered.}

\item{Qql}{A numerical value representing the average solar radiation in W/m2/hour.}

\item{Cair}{A numerical value representing the air heat capacity in J.}

\item{Pair}{A numerical value representing the air density in kg/m3.}

\item{Tmax}{Averaged maximum temperature in ºC.}

\item{Tmin}{Averaged minimum temperature in ºC.}

\item{windspeed}{Averaged wind speed in m/s.}

\item{return_raster}{If TRUE, the raster of UHI values is returned. Otherwise, a summary of raster values is returned.}

\item{verbose}{If TRUE, returns a vector with UHI value in each cell.}
}
\value{
A 'stars' object with values of UHI. Or a numerical vector or summary statistic for UHI values.
See params for more information on how to select each one.
}
\description{
The indicator calculates the urban heat island (UHI) using the DPRA guidelines of the Dutch
government.
}
\details{
DEFAULT values are the values for 'city_example' dataset in August (averaged values from 2011-2020)
}
\examples{
# Get a summary of the UHI
UHI(city_example, SVF)

# Get a 'stars' object representing UHI
uhi <- UHI(city_example, SVF, return_raster = TRUE)
plot(uhi)
}
\author{
Josep Pueyo-Ros
}
