% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{absenteeism_tbl_df}
\alias{absenteeism_tbl_df}
\title{Absenteeism from School in New South Wales}
\format{
A tibble with 146 observations and 5 variables:
\describe{
  \item{eth}{Ethnicity of the student (factor with 2 levels).}
  \item{sex}{Sex of the student (factor with 2 levels).}
  \item{age}{Age group of the student (factor with 4 levels).}
  \item{lrn}{Learning category of the student, e.g., slow learner or not (factor with 2 levels).}
  \item{days}{Number of days the student was absent from school (integer).}
}
}
\source{
Data collected from a study in rural New South Wales, Australia.
}
\usage{
data(absenteeism_tbl_df)
}
\description{
This dataset, absenteeism_tbl_df, is a tibble containing information about absenteeism from school
and certain demographic characteristics of children in rural New South Wales, Australia.
The dataset includes data from 146 randomly sampled students during a particular school year,
providing insights into the relationships between absenteeism and variables such as ethnicity, sex,
age group, and learning categories.
}
\details{
The dataset name has been kept as 'absenteeism_tbl_df' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
educationR package and assists users in identifying its specific characteristics.
The suffix 'tbl_df' indicates that the dataset is a tibble. The original content has not been modified
in any way.
}
