% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interpolate.R
\name{interpolate}
\alias{interpolate}
\alias{interpolate_file}
\alias{interpolate_package}
\title{Helpers for interpolating data into prompts}
\usage{
interpolate(prompt, ..., .envir = parent.frame())

interpolate_file(path, ..., .envir = parent.frame())

interpolate_package(package, path, ..., .envir = parent.frame())
}
\arguments{
\item{prompt}{A prompt string. You should not generally expose this
to the end user, since glue interpolation makes it easy to run arbitrary
code.}

\item{...}{Define additional temporary variables for substitution.}

\item{.envir}{Environment to evaluate \code{...} expressions in. Used when
wrapping in another function. See \code{vignette("wrappers", package = "glue")}
for more details.}

\item{path}{A path to a prompt file (often a \code{.md}). In
\code{interpolate_package()}, this path is relative to \code{inst/prompts}.}

\item{package}{Package name.}
}
\value{
A \{glue\} string.
}
\description{
These functions are lightweight wrappers around
\href{https://glue.tidyverse.org/}{glue} that make it easier to interpolate
dynamic data into a static prompt:
\itemize{
\item \code{interpolate()} works with a string.
\item \code{interpolate_file()} works with a file.
\item \code{interpolate_package()} works with a file in the \code{inst/prompts}
directory of a package.
}

Compared to glue, dynamic values should be wrapped in \code{{{ }}}, making it
easier to include R code and JSON in your prompt.
}
\examples{
joke <- "You're a cool dude who loves to make jokes. Tell me a joke about {{topic}}."

# You can supply valuese directly:
interpolate(joke, topic = "bananas")

# Or allow interpolate to find them in the current environment:
topic <- "applies"
interpolate(joke)


}
