% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plot.R
\name{qq_plot_output}
\alias{qq_plot_output}
\title{Make a Quantile-Quantile diagram from the output of the MCMC algorithm (DistributionAproximation)
and the algorithm that exhaustively calculates the distribution}
\usage{
qq_plot_output(estimated, true, filtered = FALSE, color = "steelblue")
}
\arguments{
\item{estimated}{Outputed object of DistributionApproximation function}

\item{true}{Outputed object of either DistributionApproximation function or True distribution
computation function}

\item{filtered}{Make use of the classic distributuion estimation or of the filtred one
(number of patient taking the cocktail > beta)}

\item{color}{The color of the dashed line of the qq-plot}
}
\value{
no returned value, should plot the quantile-quantile plot
of the estimated distribution (estimated) vs the true distribution (true).
}
\description{
Make a Quantile-Quantile diagram from the output of the MCMC algorithm (DistributionAproximation)
and the algorithm that exhaustively calculates the distribution
}
\examples{
\donttest{
data("ATC_Tree_UpperBound_2024")
data("FAERS_myopathy")

estimated_score_distribution = DistributionApproximation(epochs = 10,
            ATCtree = ATC_Tree_UpperBound_2024,
            observations = FAERS_myopathy[1:100,], Smax =2)
            
true_score_distribution = trueDistributionSizeTwoCocktail(ATCtree = ATC_Tree_UpperBound_2024,
            observations = FAERS_myopathy[1:100,], beta = 4)

qq_plot_output(estimated = estimated_score_distribution,
                true = true_score_distribution)
}
}
