% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{trueDistributionSizeTwoCocktail}
\alias{trueDistributionSizeTwoCocktail}
\title{The true distribution of the score among every size-two cocktails}
\usage{
trueDistributionSizeTwoCocktail(
  ATCtree,
  observations,
  beta,
  max_score = 100L,
  nbResults = 100L,
  num_thread = 1L
)
}
\arguments{
\item{ATCtree}{: ATC tree with upper bound of the DFS (without the root)}

\item{observations}{: observation of the AE based on the medications of each patients
(a DataFrame containing the medication on the first column and the ADR (boolean) on the second)
on which we want to compute the risk distribution}

\item{beta}{: minimum number of person taking the cocktails in order to consider it
in the beta score distribution}

\item{max_score}{: maximum number the score can take. Score greater than this 
one would be added to the distribution as the value max_score. Default is 1000}

\item{nbResults}{: Number of returned solution (Cocktail with the
best oberved score during the run), 100 by default}

\item{num_thread}{: Number of thread to run in parallel if openMP is available, 1 by default}
}
\value{
Return a List containing :
- ScoreDistribution : the distribution of the score as an array with each cells
representing the number of risks =  (index-1)/ 10
- Filtered_score_distribution : Distribution containing score for cocktails taken by at
least beta patients.
- Outstanding_score : An array of the score greater than max_score,
- Best_cocktails : the nbResults bests cocktails encountered during the run.
- Best_cocktails_beta : the nbResults bests cocktails taken by at least beta patients
encountered during the run.
- Best_scores : Score corresponding to the Best_cocktails.
- Best_scores_beta : Score corresponding to the Best_cocktails_beta.
}
\description{
The true distribution of the score among every size-two cocktails
}
\examples{
\donttest{
data("ATC_Tree_UpperBound_2024")
data("FAERS_myopathy")

size_2_score_distribution = trueDistributionSizeTwoCocktail(ATCtree = ATC_Tree_UpperBound_2024,
            observations = FAERS_myopathy[1:100,], beta = 4)
}
}
