#' Unidimensional data
#'
#' A dataset containing the responses of 3000 subjects to 40 items.
#'
#' @format A data frame with 3000 rows and 40 numeric variables named
#'   \code{V1}–\code{V40}, each representing the response to one item.
"data.u"




#' Multidimensional data
#'
#' A dataset containing the responses of 3000 subjects to 31 items on three
#' subscales (13, 12, and 6 items respectively).
#'
#' @format A data frame with 3000 rows and 31 numeric variables named
#'   \code{V1}–\code{V31}, each representing the response to one item.
"data.m"



#' Conversion table for unidimensional data.
#'
#' A dataset containing the conversion table for the unidimensional data, with first column
#' as raw scores and second column as scale scores
#'
#' @format A data frame with 41 rows and 2 variables:
#' \describe{
#'   \item{x}{raw score}
#'   \item{ss}{scale score}
#' }
"ct.u"


#' Conversion table for multidimensional data.
#'
#' A dataset containing the conversion table for the multidimensional data, with first column
#' as raw scores and second column as scale scores
#'
#' @format A data frame with 32 rows and 2 variables:
#' \describe{
#'   \item{x}{raw score}
#'   \item{ss}{scale score}
#' }
"ct.m"


#' Item parameters for unidimensional data.
#'
#' A dataset containing the item parameters for the unidimensional data, with first column
#' as \code{b} parameters and second column as \code{a} parameters
#'
#' @format A data frame with 40 rows and 2 variables:
#' \describe{
#'   \item{b}{b parameter}
#'   \item{a}{a parameter}
#' }
"ip.u"

