% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/encrypt_file.R
\name{encrypt_file}
\alias{encrypt_file}
\title{Encrypt a file}
\usage{
encrypt_file(.path, crypt_file_name = NULL, public_key_path = "id_rsa.pub")
}
\arguments{
\item{.path}{Quoted path to file to encrypt.}

\item{crypt_file_name}{Optional new name to give encrypted file. Must end with ".encryptr.bin".}

\item{public_key_path}{Quoted path to public key, created with
\code{\link{genkeys}}.}
}
\value{
The encrypted file is saved.
}
\description{
Encryption and decryption with asymmetric keys is computationally expensive.
This is how \code{\link{encrypt}} works, in order to allow each piece of data
in a data frame to be decrypted without compromise of the whole data frame.
This works on the presumption that each cell contains less than 245 bytes of
data.
}
\details{
File encryption requires a different approach as files are often larger in
size. This function encrypts a file using a a symmetric "session" key and the
AES-256 cipher. This key is itself then encrypted using a public key
generated using \code{\link{genkeys}}. In OpenSSL this combination is
referred to as an envelope.
}
\examples{
# This will run:
# Create example file to encrypt
# write.csv(gp, "gp.csv")
# genkeys()
# encrypt_file("gp.csv")

# For CRAN and testing:
\dontrun{
# Run only once in decrypt_file example
temp_dir = tempdir() # temp directory for testing only
genkeys(file.path(temp_dir, "id_rsa"))
write.csv(gp, file.path(temp_dir, "gp.csv"))
encrypt_file(file.path(temp_dir, "gp.csv"), public_key_path = file.path(temp_dir, "id_rsa.pub"))
}
}
