# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Spatial distances
#'
#' @param x matrix with values
#' @param center numeric value (double) with the value of the focal cell
#' @param res numeric value (double) of the spatial resolution of the matrix
#' @return Vector with values the distances between x and center
distances <- function(x, center, res) {
    .Call(`_enerscape_distances`, x, center, res)
}

#' Energy Landscape
#'
#' @param slope vector with slopes
#' @param distance vector with distances
#' @param mass body mass of species (kg)
#' @param res numeric value (double) of the spatial resolution of the matrix
#' @param kcal (boolean) if to return the result in kCal (true) or J (false)
#' @return Vector with the energy cost of locomotion (EnergyScape)
energy <- function(mass, slope, distance, res, kcal) {
    .Call(`_enerscape_energy`, mass, slope, distance, res, kcal)
}

#' Energy Landscape
#'
#' @param x matrix with values the elevation.
#' @param n (integer) number of neighbours to consider (either 4 or 8).
#' @param mass body mass of species (kg).
#' @param res numeric value (double) of the spatial resolution of the matrix.
#' @param kcal (boolean) if to return the result in kCal (true) or J (false).
#' @return Matrix with the energy cost of locomotion (EnergyScape).
energyscape <- function(x, mass, n, res, kcal) {
    .Call(`_enerscape_energyscape`, x, mass, n, res, kcal)
}

#' Energy Landscape for walking people
#'
#' @param v speed
#' @param slope vector with slopes
#' @param distance vector with distances
#' @param mass body mass of species (kg)
#' @param res numeric value (double) of the spatial resolution of the matrix
#' @param kcal (boolean) if to return the result in kCal (true) or J (false)
#' @return Vector with the energy cost of locomotion (EnergyScape)
energyHuman <- function(mass, v, slope, distance, res, kcal) {
    .Call(`_enerscape_energyHuman`, mass, v, slope, distance, res, kcal)
}

#' Energy Landscape
#'
#' @param x matrix with values the elevation.
#' @param v speed
#' @param n (integer) number of neighbours to consider (either 4 or 8).
#' @param mass body mass of species (kg).
#' @param res numeric value (double) of the spatial resolution of the matrix.
#' @param kcal (boolean) if to return the result in kCal (true) or J (false).
#' @return Matrix with the energy cost of locomotion (EnergyScape).
energyscapeHuman <- function(x, mass, v, n, res, kcal) {
    .Call(`_enerscape_energyscapeHuman`, x, mass, v, n, res, kcal)
}

#' Neighbours
#'
#' @param i row index
#' @param j column index
#' @param n number of neighbours (4 or 8)
#' @param x matrix with values
#' @return Vector with values the neighours of x
neighbours <- function(i, j, n, x) {
    .Call(`_enerscape_neighbours`, i, j, n, x)
}

#' Slopes
#'
#' @param x matrix with values
#' @param center numeric value (double) with the value of the focal cell
#' @param res numeric value (double) of the spatial resolution of the matrix
#' @return Vector with values the slopes (degrees) between x and center
slope <- function(x, center, res) {
    .Call(`_enerscape_slope`, x, center, res)
}

#' Slopes in radians
#'
#' @param x matrix with values
#' @param center numeric value (double) with the value of the focal cell
#' @param res numeric value (double) of the spatial resolution of the matrix
#' @return Vector with values the slopes (degrees) between x and center
slopeRadiant <- function(x, center, res) {
    .Call(`_enerscape_slopeRadiant`, x, center, res)
}

