% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{printEnrich}
\alias{printEnrich}
\title{printEnrich}
\usage{
printEnrich(
  data,
  prefix = "enrichr",
  showTerms = NULL,
  columns = c(1:9),
  outFile = c("txt", "excel")
)
}
\arguments{
\item{data}{(Required). Output list object from the \code{"enrichr"} function.}

\item{prefix}{(Optional). Prefix of output file. Default is \code{"enrichr"}.}

\item{showTerms}{(Optional). Number of terms to show.
Default is \code{NULL} to print all terms.}

\item{columns}{(Optional). Columns from each entry of data.
Default is \code{c(1:9)} to print all columns.
* Results without background: 1-"Term", 2-"Overlap", 3-"P.value", 
4-"Adjusted.P.value", 5-"Old.P.value", 6-"Old.Adjusted.P.value", 
7-"Odds.Ratio", 8-"Combined.Score", 9-"Combined.Score".
* In results with background, the second column is "Rank" if terms are not identical 
with those annotated in the Enrichr GMT files}

\item{outFile}{(Optional). Output file format, choose from "txt" and "excel". 
Default is "txt".}
}
\description{
Print Enrichr results
}
\details{
Print Enrichr results from the selected gene-set libraries to individual text files 
or a Excel spreadsheet.
}
\examples{
# data(input) # Load example input genes
# if (getOption("enrichR.live")) {
#   enrichRLive <- TRUE
#   dbs <- listEnrichrDbs()
#   if(is.null(dbs)) enrichRLive <- FALSE
#   dbs <- c("GO_Molecular_Function_2023", "GO_Cellular_Component_2023",
#            "GO_Biological_Process_2023")
#   enriched <- enrichr(input, dbs)
#   print(head(enriched[[1]]))
#   # if (enrichRLive) printEnrich(enriched, outFile = "excel")
# }
}
\author{
Wajid Jawaid \email{wajid.jawaid@gmail.com}

I-Hsuan Lin \email{i-hsuan.lin@manchester.ac.uk}
}
