% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extremevalue.R
\name{extremal.index.runs}
\alias{extremal.index.runs}
\title{Extremal index estimation (Smith and Weissman, 1994) - Only intended for developer use}
\usage{
extremal.index.runs(x, u, r)
}
\arguments{
\item{x}{a numeric vector of observations.}

\item{u}{a numeric value giving threshold.}

\item{r}{a positive integer giving the value of runs parameter (Smith and Weissman, 1994).}
}
\value{
a numeric value of an extremal index estimate
}
\description{
Estimation of an extremal index using the runs estimator suggested in (Smith and Weissman, 1994).
The function is called by \code{\link{KRDetect.outliers.EV}} and is not intended for use by regular users of the package.
}
\details{
This function computes the runs estimate of extremal index suggested in (Smith and Weissman, 1994).
The function is exported for developer use only. It does not perform any checks on inputs since it is only convenience function used within \code{\link{KRDetect.outliers.EV}}.
}
\references{
Smith, RL, Weissman, I (1994). Estimating the Extremal Index. Journal of the Royal Statistical Society, Series B, 56, 515-529.
}
