% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rtoolkit.R
\name{ENgetcount}
\alias{ENgetcount}
\title{Get number of network elements.}
\usage{
ENgetcount(compcode)
}
\arguments{
\item{compcode}{A character string, integer or numeric specifying the component code(s) 
(see below).}
}
\value{
The number of network components.
}
\description{
\code{ENgetcount} retrieves the number of network components of a specific type.
}
\details{
Component codes consist of the following:
  \tabular{lll}{
  \code{EN_NODECOUNT}    \tab 0 \tab Nodes\cr
  \code{EN_TANKCOUNT}    \tab 1 \tab Reservoirs and tank nodes\cr
  \code{EN_LINKCOUNT}    \tab 2 \tab Links\cr
  \code{EN_PATCOUNT}     \tab 3 \tab Time patterns\cr
  \code{EN_CURVECOUNT}   \tab 4 \tab Curves\cr
  \code{EN_CONTROLCOUNT} \tab 5 \tab Simple controls\cr
  \code{EN_RULECOUNT} \tab 5 \tab Simple controls
  }

  The number of junctions in a network equals the number of nodes minus the number of tanks and reservoirs.
}
\examples{
# path to Net1.inp example file included with this package
inp <- file.path( find.package("epanet2toolkit"), "extdata","Net1.inp")  
ENopen( inp, "Net1.rpt")
ENgetcount(0)
ENgetcount("EN_NODECOUNT")
ENclose()
}
