% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epichains.R
\name{.epichains_summary}
\alias{.epichains_summary}
\title{Create an \verb{<epichains_summary>} object}
\usage{
.epichains_summary(
  chains_summary,
  n_chains,
  offspring_dist,
  statistic = c("size", "length"),
  stat_threshold = Inf
)
}
\arguments{
\item{chains_summary}{A numeric \verb{<vector>} of chain sizes and lengths.}

\item{n_chains}{Number of chains to simulate.}

\item{offspring_dist}{Offspring distribution: a \verb{<function>} like the ones
provided by R to generate random numbers from given distributions (e.g.,
\code{\link{rpois}} for Poisson). More specifically, the function needs to
accept at least one argument, \code{n}, which is the number of random
numbers to generate. It can accept further arguments, which will be passed
on to the random number generating functions. Examples that can be provided
here are \code{rpois} for Poisson distributed offspring, \code{rnbinom} for negative
binomial offspring, or custom functions.}

\item{statistic}{The chain statistic to track as the
stopping criteria for each chain being simulated when \code{stat_threshold} is not
\code{Inf}; A \verb{<string>}. It can be one of:
\itemize{
\item "size": the total number of cases produced by a chain before it goes
extinct.
\item "length": the total number of generations reached by a chain before
it goes extinct.
}}

\item{stat_threshold}{A stopping criterion for individual chain simulations;
a positive number coercible to integer. When any chain's cumulative statistic
reaches or surpasses \code{stat_threshold}, that chain ends. It also serves as a
censoring limit so that results above the specified value, are set to \code{Inf}.
Defaults to \code{Inf}.}
}
\value{
An \verb{<epichains_summary>} object.
}
\description{
\code{epichains_summary()} constructs an \verb{<epichains_summary>} object.

An \verb{<epichains_summary>} object is a \verb{<vector>} of the simulated
chain sizes or lengths. It also stores information on the number of chains
simulated, and the statistic that was tracked.
}
\author{
James M. Azam
}
\keyword{internal}
