% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/literature.R
\name{literature_gwas}
\alias{literature_gwas}
\title{Literature evidence regarding a GWAS trait}
\usage{
literature_gwas(trait, semmed_predicate = NULL, mode = c("table", "raw"))
}
\arguments{
\item{trait}{A trait name}

\item{semmed_predicate}{Either NULL which returns entries from
all predicates, or a SemMed predicate e.g. "DIAGNOSES" or "ASSOCIATED_WITH"}

\item{mode}{If \code{mode = "table"}, returns a data frame
(a \href{https://tibble.tidyverse.org/}{\code{tibble}} as per
\href{https://style.tidyverse.org/}{\code{tidyverse}} convention).
If \code{mode = "raw"}, returns a raw response from EpiGraphDB API
with minimal parsing done by \href{https://httr.r-lib.org/}{\code{httr}}.}
}
\value{
Data from \code{GET /literature/gwas}
}
\description{
\href{https://docs.epigraphdb.org/api/api-endpoints/#get-literaturegwas}{\code{GET /literature/gwas}}
}
\examples{
\dontrun{
literature_gwas(trait = "Body mass index")
}
}
