% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_params.R
\name{.convert_params_nbinom}
\alias{.convert_params_nbinom}
\title{Convert parameters of the negative binomial distribution to summary
statistics}
\usage{
.convert_params_nbinom(...)
}
\arguments{
\item{...}{<\code{\link[rlang:dyn-dots]{dynamic-dots}}> \code{Numeric} named parameter(s)
used to convert to summary statistics. An example is the \code{meanlog} and
\code{sdlog} parameters of the lognormal (\code{lnorm}) distribution.}
}
\value{
A list of eight elements including: mean, median, mode,
variance (\code{var}), standard deviation (\code{sd}), coefficient of variation (\code{cv}),
skewness, and ex_kurtosis.
}
\description{
Convert the probability (\code{prob}) and dispersion parameters of
the negative binomial distribution to a number of summary statistics which
can be calculated analytically given the negative binomial parameters.
One exception is the median which is calculated using \code{\link[=qnbinom]{qnbinom()}} as no
analytical form is available.

The parameters are \code{prob} and \code{dispersion} (which is also commonly
represented as \emph{r}).
}
\keyword{internal}
