% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epitrax.R
\name{epitrax_write_csvs}
\alias{epitrax_write_csvs}
\title{Write reports from EpiTrax object to CSV files}
\usage{
epitrax_write_csvs(epitrax, fsys)
}
\arguments{
\item{epitrax}{Object of class \code{epitrax}.}

\item{fsys}{Filesystem list containing paths for internal and public reports.}
}
\value{
The original EpiTrax object, unchanged.
}
\description{
\code{epitrax_write_csvs} writes the internal and public reports from an EpiTrax
object to CSV files in the specified filesystem. Doesn't write files if
the EpiTrax config setting \code{generate_csvs} is set to false.
}
\examples{
fsys <- list(
  internal = file.path(tempdir(), "internal_reports"),
  public = file.path(tempdir(), "public_reports"),
  settings = file.path(tempdir(), "report_settings")
)
data_file <- system.file("sample_data/sample_epitrax_data.csv",
                         package = "epitraxr")
config_file <- system.file("tinytest/test_files/configs/good_config.yaml",
                           package = "epitraxr")
disease_lists <- list(
  internal = "use_defaults",
  public = "use_defaults"
)

epitrax <- setup_epitrax(
  filepath = data_file,
  config_file = config_file,
  disease_list_files = disease_lists
) |>
 epitrax_preport_ytd_rates() |>
 epitrax_write_csvs(fsys = fsys)

# Cleanup
unlink(unlist(fsys, use.names = FALSE), recursive = TRUE)
}
