% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{standardize_report_diseases}
\alias{standardize_report_diseases}
\title{Standardize diseases for report}
\usage{
standardize_report_diseases(data, diseases)
}
\arguments{
\item{data}{Dataframe. Current report data.}

\item{diseases}{Character vector. Diseases to include in the report.}
}
\value{
Report data with rows for all diseases to report.
}
\description{
'standardize_report_diseases' removes rows from the data that
shouldn't appear in the report and adds rows for diseases that
should be in the report, but weren't in the input dataset.
Added rows are filled with 0s.
}
\examples{
df <- data.frame(disease=c("A","B","D"), counts=c(5,7,8))
standardize_report_diseases(df, c("A","C"))
}
