% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions-server.R
\name{plot_reproductive_epi}
\alias{plot_reproductive_epi}
\title{Plot Rt}
\usage{
plot_reproductive_epi(model)
}
\arguments{
\item{model}{The model object}
}
\value{
A plot displaying the reproductive number for the model over the
course of the simulation
}
\description{
This function generates a plot of the reproductive number over time
}
\examples{
library(epiworldR) # for ModelSEIRCONN function
model <- ModelSEIRCONN("COVID-19", n = 1000, prevalence = 0.05,
                       contact_rate = 4, transmission_rate = 0.1,
                       incubation_days = 7, recovery_rate = 0.14)
run(model, ndays = 100, seed = 123)
plot_reproductive_epi(model)
}
\seealso{
Other Server side functions: 
\code{\link{find_scale}()},
\code{\link{plot_epi}()},
\code{\link{pop_generator}()}
}
\concept{Server side functions}
