% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/writeNeuroTable.R
\name{createNeuroTable}
\alias{createNeuroTable}
\title{Create the final resulting data frame}
\usage{
createNeuroTable(atchashda, atchashsec, dneuromaxk)
}
\arguments{
\item{atchashda}{hashmap retrieved from readAtcMapIntoHashMapDrugNamesAtcCodes}

\item{atchashsec}{hashmap retrieved from readSecondLevelATC}

\item{dneuromaxk}{data frame containing columns for each intersection, ATC class, and reference list}
}
\value{
data frame containing drug names with additional columns listing association to ATC classes
}
\description{
Create the final resulting data frame
}
\examples{
utils::data(rawDrugNamesCoOcEpSO, package="epos")
utils::data(rawDrugNamesCoOcESSO, package="epos")
utils::data(rawDrugNamesCoOcEPILONT, package="epos")
utils::data(rawDrugNamesCoOcEPISEM, package="epos")
utils::data(rawDrugNamesCoOcFENICS, package="epos")
atchashda <-
readAtcMapIntoHashMapDrugNamesAtcCodes(
  system.file("extdata", "db-atc.map", package = "epos"), "\t")
atchashaa <-
  readAtcMapIntoHashMapAtcCodesAtcNames(
    system.file("extdata", "db-atc.map", package = "epos"), "\t")
atchashsec <-
  readSecondLevelATC(
    system.file("extdata", "atc-secondlevel.map", package = "epos"), "\t")
epso <- rawDrugNamesCoOcEpSO
neuroepso <- filterNeuroDrugs(epso, atchashda)
esso <- rawDrugNamesCoOcESSO
neuroesso   <- filterNeuroDrugs(esso, atchashda)
epi <- rawDrugNamesCoOcEPILONT
neuroepi    <- filterNeuroDrugs(epi, atchashda)
episem <- rawDrugNamesCoOcEPISEM
neuroepisem <- filterNeuroDrugs(episem, atchashda)
fenics <- rawDrugNamesCoOcFENICS
neurofenics <- filterNeuroDrugs(fenics, atchashda)
mx <- max(
    c(length(neuroepso), length(neuroesso), length(neuroepi),
     length(neuroepisem), length(neurofenics)))
dneuro <-
  data.frame(EpSO = c(neuroepso, rep(1, (mx-length(neuroepso)))),
             ESSO = c(neuroesso, rep(1, (mx-length(neuroesso)))),
             EPILONT = c(neuroepi, rep(1, (mx-length(neuroepi)))),
             EPISEM = c(neuroepisem, rep(1, (mx-length(neuroepisem)))),
             FENICS = c(neurofenics, rep(1, (mx-length(neurofenics)))))
dneuromaxk <- TopKLists::calculate.maxK(dneuro, L=5, d=5, v=10)
neurotable <- createNeuroTable(atchashda, atchashsec, dneuromaxk)
}
