% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mstAddIntervention.R
\name{mstAddIntervention}
\alias{mstAddIntervention}
\title{Add a New Intervention Group to Multisite Trial (MST)}
\usage{
mstAddIntervention(
  originalData,
  ns,
  np,
  es,
  attritionrate,
  intper,
  outcome,
  interventions,
  schoolsID,
  pupilsID,
  continuous_covariates,
  categorical_covariates
)
}
\arguments{
\item{originalData}{A data frame containing the variables including outcome, predictors, the clustering variable, and the intervention for MST design.}

\item{ns}{The number of schools to assign to the new intervention group.}

\item{np}{The number of pupils per new school.}

\item{es}{The standardized effect size for the new intervention group.}

\item{attritionrate}{The proportion of pupils in the new group to drop due to attrition.}

\item{intper}{Proportion of pupils per new school assigned to the Intervention group.}

\item{outcome}{A string specifying the name of the column containing outcome variable (e.g., post-test scores).}

\item{interventions}{A string specifying the name of the intervention assignment column.}

\item{schoolsID}{A string specifying the name of the school ID column.}

\item{pupilsID}{A string specifying the name of the pupil ID column.}

\item{continuous_covariates}{A character vector specifying the names of continuous covariates.}

\item{categorical_covariates}{A character vector specifying the names of categorical covariates (converted to factors).}
}
\value{
A \code{data.frame} containing the combined dataset with the newly added intervention group and simulated outcomes.
}
\description{
This function adds a new intervention group to an existing Multisite Trial (MST) dataset. It fits a
linear mixed-effects model to the original data, then uses its estimates to generate post-test
outcomes for the new group, incorporating random intercepts, slopes, and user-defined effect size.
}
\details{
The function:
\itemize{
\item Fits a linear mixed-effects model (\code{lmer}) with random slopes and intercepts using existing MST data.
\item Simulates new schools and pupils, assigning intervention randomly by specified percentage.
\item Simulates attrition by removing post-test scores at random.
}
}
\examples{
data(mst4armSimData)
new_mst5armData <- mstAddIntervention(originalData = mst4armSimData, ns = 2, np = 100, es = 0.3,
intper = 0.5, attritionrate = 0.1, outcome = "posttest", interventions = "interventions",
schoolsID = "schools", pupilsID = "pupils", 
continuous_covariates = c("pretest"), categorical_covariates = c("gender", "ethnicity"))
head(new_mst5armData)

}
\seealso{
\code{\link[lme4]{lmer}} from the \pkg{lme4} package
}
