% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{VAS}
\alias{VAS}
\title{EQ-5D-3L VAS value set data}
\format{
An object of class \code{data.frame} with 21 rows and 11 columns.
}
\source{
Oppe, M., Szende, A., & de Charro, F. (2007), Comparative review of Visual Analogue Scale value sets.
  In Szende, A., Oppe, M., & Devlin, N. (Ed.), EQ-5D Value Sets: Inventory, Comparative Review
  and User Guide (pp. 37-38). Dordrecht, The Netherlands: Springer.

\itemize{
\item{\strong{Belgium}: Cleemput I. A social preference valuations set for EQ-5D health states in Flanders, Belgium. Eur J Health Econ. 2010 Apr;11(2):205-13. \doi{10.1007/s10198-009-0167-0}. Epub 2009 Jul 7. PMID: 19582490.}
\item{\strong{Denmark}: Wittrup-Jensen KU, Lauridsen JT, Gudex C, Brooks R, Pedersen KM. Estimating Danish EQ-5D tariffs using TTO and VAS. In: Norinder A, Pedersen K, Roos P, editors. Proceedings of the 18th Plenary Meeting of the EuroQol Group. 2001. Copenhagen, Denmark. IHE, The Swedish Institute for Health Economics, 2002: 257-292.}
\item{\strong{Europe}: Greiner W, Weijnen T, Nieuwenhuizen M, et al. A single European currency for EQ-5D health states. Results from a six country study. Eur J Health Econ 2003; 4(3):222-231.}
\item{\strong{Finland}: Ohinmaa, A., & Sintonen, H. (1998, October). Inconsistencies and modelling of the Finnish EuroQol (EQ-5D) preference values. In EuroQol Plenary Meeting (pp. 1-2). Health Economics and Health System Research, University of Hannover.}
\item{\strong{Germany}: Claes, C., Greiner, W., Uber, A., & Graf von der Schulenburg, J. M. (1999). An interview-based comparison of the TTO and VAS values given to EuroQol states of health by the general German population. In Proceedings of the 15th Plenary Meeting of the EuroQol Group. Hannover, Germany: Centre for Health Economics and Health Systems Research, University of Hannover (pp. 13-38).}
\item{\strong{Iran}: Goudarzi R, Zeraati H, Akbari Sari A, Rashidian A, Mohammad K. Population-Based Preference Weights for the EQ-5D Health States Using the Visual Analogue Scale (VAS) in Iran. Iran Red Crescent Med J. 2016 Feb 13;18(2):e21584. \doi{10.5812/ircmj.21584}. PMID: 27186384.}
\item{\strong{Malaysia}: Yusof FA, Goh A, Azmi S. Estimating an EQ-5D value set for Malaysia using time trade-off and visual analogue scale methods. Value Health. 2012 Jan-Feb;15(1 Suppl):S85-90. \doi{10.1016/j.jval.2011.11.024}. PMID: 22265073.}
\item{\strong{New Zealand}: Devlin NJ, Hansen P, Kind P, Williams A. Logical inconsistencies in survey respondents' health state valuations -- a methodological challenge for estimating social tariffs. Health Econ. 2003 Jul;12(7):529-44. \doi{10.1002/hec.741}. PMID: 12825206.}
\item{\strong{Slovenia}: Prevolnik Rupel V, Rebolj M. The Slovenian VAS Tariff based on valuations of EQ-5D health states from the general population. In: Cabasés JM, Gaminde I, editors. Proceedings of the 17th Plenary Meeting of the EuroQol Group. Universidad Pública de Navarra 2001; 23-47.}
\item{\strong{Spain} Badia X, Roset M, Monserrat S, Herdman M. The Spanish VAS tariff based on valuation of EQ-5D health states from the general population. In: Rabin RE et al, editors. EuroQol Plenary meeting Rotterdam 1997, 2-3 October. Discussion papers. Centre for Health Policy & Law, Erasmus University, Rotterdam, 1998; 93-114}
\item{\strong{UK} MVH Group. The Measurement and Valuation of Health. Final report on the modeling of valuation tariffs. York Centre for Health Economics, 1995.}
}
}
\usage{
VAS
}
\description{
Coefficients for the estimation of the EQ-5D-3L index values based on VAS valuation studies
 for Belgium, Denmark, Europe, Finland, Germany, Iran, Malaysia, New Zealand,
 Slovenia, Spain and UK.
}
\keyword{datasets}
