% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EQ_functions.R
\name{toEQ5Dindex}
\alias{toEQ5Dindex}
\title{toEQ5DIndex}
\usage{
toEQ5Dindex(x, dim.names = c("mo", "sc", "ua", "pd", "ad"))
}
\arguments{
\item{x}{A data.frame, matrix, or vector containing dimension levels. Should have column names corresponding to the dim.names argument.}

\item{dim.names}{A vector of dimension names in data.frame/matrix/vector x}
}
\value{
A vector of 5-digit EQ-5D health state indexes.
}
\description{
Generate EQ-5D state vector from data.frame/matrix or named vector with dimensions.
}
\examples{
toEQ5Dindex(c(1,2,3,4,5))

example_data <- as.data.frame(matrix(data = c(1, 2, 3, 4, 5, 
                                              5, 4, 3, 2, 1, 
                                              3, 2, 1, 2, 3), 
                                     ncol = 5, 
                                     byrow = TRUE, 
                                     dimnames = list(NULL, c("mo", "sc", "ua", "pd", "ad"))))
example_data$irrelevant <- c(6,5,3)
toEQ5Dindex(example_data)
}
