#' ACT Mathematics Test Scores
#' 
#' This dataset contains score distributions for two forms of the ACT
#' mathematics test, as presented in table 2.5 of \emph{Test Equating, Scaling,
#' and Linking} (Kolen and Brennan, 2004; p. 50).
#' 
#' @name ACTmath
#' @docType data
#' @format A 41 by 3 \code{data.frame} containing the score scale, frequencies
#' for form X, and frequencies for form Y.
#' @source Kolen, M. J., and Brennan, R. L. (2004). \emph{Test Equating,
#' Scaling, and Linking}. (2nd ed.), New York: Springer.
#' 
#' The dataset is also provided with the equating software RAGE, available at
#' the following link:
#' \url{https://education.uiowa.edu/casma/computer-programs}
#' @keywords datasets
"ACTmath"