% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InitErgmTerm.multinet.R
\name{Networks}
\alias{Networks}
\title{A multinetwork network representation.}
\usage{
Networks(...)
}
\arguments{
\item{...}{network specification, in one of two formats:
\enumerate{
\item An (optionally named) list of networks with same directedness and bipartedness (but possibly different sizes).
\item Several networks as (optionally named) arguments.
}}
}
\value{
A \code{\link[network:network]{network}} object comprising the provided networks, with multinetwork metadata.

Due to certain optimizations, the resulting \code{\link[network:network]{network}} object's network and vertex attributes should be treated as read-only: do not modify them. If you need to change existing attributes or add new ones, do so on the input networks and call \code{Networks(...)} again.
}
\description{
A function for specifying the LHS of a multi-network
(a.k.a. multilevel) ERGM. Typically used in conjunction with the
\code{\link[=N-ergmTerm]{N()}} term operator.
}
\examples{

data(samplk)

# Method 1: list of networks
monks <- Networks(list(samplk1, samplk2))
ergm(monks ~ N(~edges))

# Method 2: networks as arguments
monks <- Networks(samplk1, samplk2)
ergm(monks ~ N(~edges))

}
\seealso{
\code{\link[ergm:ergmTerm]{ergmTerm}} for specific terms.

\code{vignette("Goeyvaerts_reproduction")} for a demonstration.
}
