% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InitWtErgmTerm_rank.R
\name{rank.nonconformity-ergmTerm}
\alias{rank.nonconformity-ergmTerm}
\alias{InitWtErgmTerm.rank.nonconformity}
\title{Nonconformity}
\usage{
# valued: rank.nonconformity(to, par)
}
\arguments{
\item{to}{which controls to whom an ego may conform:
\itemize{
\item \code{"all"} (the default): Nonconformity to all
egos is counted. A lower-than-chance
value of this statistic and/or a negative coefficient implies a
degree of consensus in the network.
\item \code{"localAND"}: Nonconformity of \eqn{i} to ego \eqn{l} regarding the relative ranking
of \eqn{j} and \eqn{k} is only counted if \eqn{i} ranks \eqn{l}
over both \eqn{j} and \eqn{k} . A lower-than-chance
value of this statistic and/or a negative coefficient implies a
form of hierarchical transitivity in the network. This is the
recommended form of local nonconformity (over \code{"local1"}
and \code{"local2"} ).
\item \code{"local1"}: Nonconformity of \eqn{i} to ego \eqn{l} regarding the relative ranking
of \eqn{j} and \eqn{k} is only counted if \eqn{i} ranks \eqn{l} over \eqn{j} .
\item \code{"local2"}: Nonconformity of \eqn{i} to ego \eqn{l} regarding the relative ranking
of \eqn{j} and \eqn{k} is only counted if \eqn{i} ranks \eqn{l} over \eqn{k} .
\item \code{"thresholds"}: Nonconformity of \eqn{i} to ego \eqn{l} regarding the relative ranking
of \eqn{j} and \eqn{k} is only counted if \eqn{i} ranks \eqn{l} above \code{par}, where \code{par}
can be a vector with multiple thresholds.
\item \code{"geometric"}: Nonconformity of \eqn{i} to ego \eqn{l} regarding the relative ranking
of \eqn{j} and \eqn{k} is weighted by \code{par} taken to the power of the rank of \eqn{l} by \eqn{i} , where \code{par}
is a scalar.
}}

\item{par}{additional parameters for some types of nonconformity.}
}
\description{
Measures the amount of "nonconformity" in the network: configurations where an ego
\eqn{i} ranks an alter \eqn{j} over another alter \eqn{k}, but
ego \eqn{l} ranks \eqn{k} over \eqn{j} .
}
\seealso{
\code{\link[ergm:ergmTerm]{ergmTerm}} for index of model terms currently visible to the package.

\Sexpr[results=rd,stage=render]{ergm:::.formatTermKeywords("ergmTerm", "rank.nonconformity", "subsection")}
}
\concept{directed}
\concept{ordinal}
\concept{triad-related}
\concept{valued}
