% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/approx.hotelling.diff.test.R
\name{spectrum0.mvar}
\alias{spectrum0.mvar}
\title{Multivariate version of \code{coda}'s \code{\link[coda:spectrum0.ar]{spectrum0.ar()}}.}
\usage{
spectrum0.mvar(
  x,
  order.max = NULL,
  aic = is.null(order.max),
  tol = .Machine$double.eps^0.5,
  ...
)
}
\arguments{
\item{x}{a matrix with observations in rows and variables in
columns.}

\item{order.max}{maximum (or fixed) order for the AR model.}

\item{aic}{use AIC to select the order (up to \code{order.max}).}

\item{tol}{tolerance used in detecting multicollinearity. See Note below.}

\item{...}{additional arguments to \code{\link[=ar]{ar()}}.}
}
\value{
A square matrix with dimension equalling to the number of
columns of \code{x}, with an additional attribute \code{"infl"} giving the
factor by which the effective sample size is reduced due to
autocorrelation, according to the \insertCite{VaFl15m;textual}{ergm}
estimate for ESS.
}
\description{
Its return value, divided by \code{nrow(cbind(x))}, is the estimated
variance-covariance matrix of the sampling distribution of the mean
of \code{x} if \code{x} is a multivatriate time series with AR(\eqn{p}) structure, with
\eqn{p} determined by AIC.
}
\note{
\code{\link[=ar]{ar()}} fails if \code{crossprod(x)} is singular. This is
is remedied as follows:
\enumerate{
\item Standardize the variables.
\item Use the eigenvectors to map the variables onto their principal components.
\item Use the eigenvalues to standardize the principal components.
\item Drop those components whose standard deviation differs from 1 by more than \code{tol}. This should filter out redundant components or those too numerically unstable.
\item Call \code{\link[=ar]{ar()}} and calculate the variance.
\item Reverse the mapping in steps 1-4 to obtain the variance of the original data.
}
}
