% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check-interval.R
\name{check_interval}
\alias{check_interval}
\title{Check If Argument Is in Interval}
\usage{
check_interval(
  x,
  valid,
  name = NULL,
  general = NULL,
  specific = NULL,
  supplement = NULL,
  ...
)
}
\arguments{
\item{x}{The argument to check, which can be any object.}

\item{valid}{A numeric vector of length 2, which represents the valid
closed interval. If \code{valid} is an integer vector,
\code{x} must also be an integer. \code{valid} can contain \code{NA}. For example,
\code{c(1, NA)} means \code{x} must be no less than 1.}

\item{name}{A single character which gives the argument's name.
The name is used in the error message. By default, the name of the
argument passed to argument \code{x} is captured automatically.}

\item{general}{Optional. A single character which is used to give a
general statement of the error incurred. By default, this is generated
automatically.}

\item{specific}{Optional. A single character which gives a detailed
description of the error. \code{\link[glue:glue]{glue::glue()}} syntax can be used, see
"Examples" section. By default, this is generated automatically.}

\item{supplement}{Optional. A (named) character vector which gives some
additional information about the error. The names are used to create
bullets, see \code{\link[=throw]{throw()}}. By default, this is left empty.}

\item{...}{Optional. Additional arguments which can be retrieved with
\code{\link[=tryCatch]{tryCatch()}}.}
}
\value{
returns an invisible \code{NULL} if the argument is valid, or
generates an error message.
}
\description{
Check if an argument is a number in an interval, and if not,
generate an error message.
}
\examples{
x <- 3.3

check_interval(x, c(1, 5))

\dontrun{
check_interval(x, c(1L, 5L))
check_interval(x, c(4, NA))
check_interval(x, c(NA, 2))
}
}
\seealso{
\code{vignette("erify")} for a gentle introduction to this package.
}
