% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/agg_to_daily.R
\name{fit_jags_aggreg}
\alias{fit_jags_aggreg}
\title{Fit JAGS model to aggregated data}
\usage{
fit_jags_aggreg(obs.times, Y, g, N, n.days = NULL, prm.daily, silent = FALSE)
}
\arguments{
\item{obs.times}{Numeric. Vector of observation times.}

\item{Y}{Numeric. Vector of aggregated counts.}

\item{g}{Numeric. Vector of discretized generation interval density.}

\item{N}{Numeric. Scalar population size.}

\item{n.days}{Numeric. Total number of days. if \code{NULL}, use \code{max(obs.times)}}

\item{prm.daily}{List. Parameters for daily report inference via MCMC. Elements include:
\itemize{
\item \code{method}: String. Method name to infer the daily incidence reports from aggregated ones.
Either \code{linear} or \code{renewal} is currently implemented.
The \code{linear} method simply performs a linear interpolation that matches the aggregated values.
The \code{renewal} method fits a SIR-like model using a renewal equation to infer the daily incidence.
In this case, the fitting algorithm is a Markov Chain Monte Carlo (MCMC) implemented in JAGS
and needs the parameters below (e.g., \code{burn,iter,chains,...}).
The \code{renewal} method is more adapted for short single wave epidemics as this models
i) naturally fits a single wave and ii) has longer computing time.
For longer time series, user may perfer the \code{linear} method.
\item \code{popsize}: Integer. Population size to use in MCMC simulation to infer daily observations from aggregated input data.
\item \code{burn}: Numeric. Length of burn-in period (number of days).
\item \code{iter}: Numeric. Number of iterations after burn-in period (number of days).
\item \code{chains}: Numeric. Number of chains to simulate.
\item \code{prior_R0_shape}: Shape of the (hyper-)parameter for the prior Gamma distribution for R0.
\item \code{prior_R0_rate}: Rate of the (hyper-)parameter for the prior Gamma distribution for R0.
\item \code{prior_alpha_shape}: Shape of the (hyper-)parameter for the prior Gamma distribution for alpha.
\item \code{prior_alpha_rate}: Rate of the (hyper-)parameter for the prior Gamma distribution for alpha.
\item \code{first.agg.period}: length of aggregation period for first aggregated observation (number of days); if NULL, assume same aggregation period as observed for second observation (gap between first and second observations)
}}

\item{silent}{Logical. Flag to suppress all output messages, warnings, and progress bars.}
}
\description{
Fit JAGS model to aggregated data
}
\keyword{internal}
