% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Means.R
\name{m.measures}
\alias{m.measures}
\title{Calculate grand average and individual mean amplitudes and standard deviations}
\usage{
m.measures(data, electrodes, window)
}
\arguments{
\item{data}{A data frame in the format returned from \code{\link{load.data}}}

\item{electrodes}{A single value or concatenation of several values (to be averaged)
indicating which electrodes to include in generating the plot. At this time, if the
raw data files imported using \code{\link{load.data}}) do not have a header, you
must include a capital "V" in front of the number and enclose each electrode in quotes.
(For example, electrodes = "V78", or electrodes = c("V78", "V76").)}

\item{window}{The beginning and end points of a time window of interest; this is different
from the beginning and ending times \code{epoch.st} and \code{epoch.end} defined in
\code{\link{load.data}} (you only need to define the epoch once upon importing the data).}
}
\value{
A data frame with columns labeled:
\itemize{
    \item Subject
    \item Trial Type
    \item Standard Deviation
    \item Mean Amplitude
}

A plot indicating the specified time window
}
\description{
\code{m.measures} calculates mean amplitude and standard deviation for each condition
  in the data frame, for the specified time window. Values are calculated based on grand
  average waveforms, as well as for each individual subject. Values are based on the electrode,
  or electrode cluster for dense arrays, provided in \code{electrodes}.
}
\details{
Single electrodes can be passed to the package functions, or several electrodes can
  be provided (i.e., when using dense arrays) and those electrodes will be averaged
  together as a single electrode.
}
\examples{
# Calculate mean amplitude and standard deviation
m.measures(ERPdata, electrodes = "V78", window = c(1000, 1500))

}
\author{
Travis Moore
}
