% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psns.R
\name{psns}
\alias{psns}
\title{Party System Nationalization Score}
\usage{
psns(tidy_data, method, pns = FALSE, scale = 100)
}
\arguments{
\item{tidy_data}{data.frame that contains the following variables with these names:
\itemize{
         \item{\code{election}: year of election.}
         \item{\code{unit}: the unit of analysis (province, department ...)}
         \item{\code{party}: name of the political parties that obtain votes.}
         \item{\code{votes}: votes obtained by each party.}
         \item{\code{votes_nac}: votes at national level for each party.}
        }
If the data is not structured in this way you can order it with: \code{\link{convert_esaps}}.}

\item{method}{Method to calculate Party System Nationalization Score:
\itemize{
        \item{\code{method = "Mainwaring and Jones"} or \code{method = 1}.}
        \item{\code{method = "Chhibber and Kollman"} or \code{method = 2}.}
        }}

\item{pns}{by default it is \code{FALSE}. If \code{TRUE}, the Party Nationalization Score
is calculated. In method, you must indicate: \code{method = 1}.}

\item{scale}{By default it is \code{100}, the indices will vary between 0 and 100.
If \code{scale = 1} the variation will be between 0 and 1.}
}
\value{
if \code{pns = FALSE,} return data.frame.

    if \code{pns = TRUE}, return a list with two data.frame.
    \itemize{
            \item{\code{list[[1]]}} {PSNS: Party System Nationalization Score}
            \item{\code{list[[2]]}} {PNS: Party Nationalization Score}
           }
}
\description{
Party System Nationalization Score Mainwaring and Jones (2003) and Chhibber and Kollman (2004)
}
\examples{
votes <- data.frame(election = rep(2000,4),
                    unit  = rep(c("District_1", "District_2"), each = 2),
                    party = rep(c("party_A", "party_B"), 2),
                    votes = c(0.60,0.40, 0.30, 0.70),
                    votes_nac = rep(c(0.55,0.45),2)
                   )
psns(tidy_data = votes, method = 1)
psns(tidy_data = votes, method = 1, pns = TRUE)

}
\author{
Nicolas Schmidt \email{nschmidt@cienciassociales.edu.uy}
}
