% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vars_consist.R
\name{vars_consist}
\alias{vars_consist}
\title{Create Unique Values Dataframe}
\usage{
vars_consist(.df, group, vars, max_length = 4)
}
\arguments{
\item{.df}{A dataframe containing the data.}

\item{group}{The name of the group variable.}

\item{vars}{A vector of variable names to consider.}

\item{max_length}{The maximum length of the merged values. If the length of the merged values exceeds this value, the values are truncated and an ellipsis is added at the end. Default is 4.}
}
\value{
A dataframe with unique values for each variable within each group modality.
}
\description{
This function takes a dataframe, a group variable, and a vector of variables. It creates a new dataframe that contains unique values for each variable within each group modality.
Only one group variable should be used, otherwise, an error will be thrown.
The resulting dataframe has the group variable as the first column and each variable's unique values as subsequent columns.
The \code{merge_val} function is applied to merge the unique values within each group.
}
\examples{
vars_consist(esmdata_sim, group = "id", vars = c("age", "cond_dyad"))
}
